import { p as provideApi, u as useUserSession, R as ROLES, b as _sfc_main$5 } from "./index.89072ba7.js";
import { _ as _sfc_main$6 } from "./VButtons.5078402e.js";
import { _ as _sfc_main$7 } from "./KanbanDropdown.e4b6bc53.js";
import { _ as _sfc_main$3 } from "./VPlaceloadText.363df2d8.js";
import { _ as _sfc_main$4 } from "./VLoader.f5ba2b30.js";
import { G as defineStore, d as defineComponent, r as ref, o as openBlock, b as createElementBlock, p as createBaseVNode, n as normalizeClass, A as createTextVNode, B as toDisplayString, E as createBlock, Z as createCommentVNode, t as createVNode, v as withCtx, F as Fragment, a5 as onMounted, a6 as onUnmounted, s as unref, Y as renderList, D as useHead } from "./vendor.48417147.js";
import { b as useMesaSession, C as COMMAND_BAR, c as COMMAND_KITCHEN, M as MesaService, a as use, u as useCompanySession } from "./mesaService.21a7d313.js";
import { p as pageTitle } from "./sidebarLayoutState.08f3edf0.js";
import "./VDropdown.31f1f578.js";
import "./VIcon.1e784500.js";
const { getMesas2 } = useMesaSession();
const useCommandSession = defineStore("commandSession", () => {
  function productStatusFilter(status, command_type) {
    const products = [];
    if (command_type == "kitchen") {
      getMesas2().forEach((mesa) => {
        mesa.products.forEach((item) => {
          const newItem = item;
          newItem.mesa = mesa.id;
          newItem.statusKitchen === status ? products.push(newItem) : "";
        });
      });
    } else {
      getMesas2().forEach((mesa) => {
        mesa.products.forEach((item) => {
          const newItem = item;
          newItem.mesa = mesa.id;
          newItem.statusBar === status ? products.push(newItem) : "";
        });
      });
    }
    return products;
  }
  async function changeStatus(product, type) {
    const mesa = getMesas2().find((mesa2) => mesa2.id == product.mesa);
    mesa && mesa.products.forEach(async (item) => {
      if (type.code === COMMAND_BAR.code) {
        product.id == item.id ? item.statusBar = item.statusBar + 1 : "";
      }
      if (type.code === COMMAND_KITCHEN.code) {
        product.id == item.id ? item.statusKitchen = item.statusKitchen + 1 : "";
      }
    });
    if (mesa) {
      await MesaService.saveMesa(mesa);
      use.updateTable(mesa);
    }
  }
  return {
    productStatusFilter,
    changeStatus
  };
});
var CommandProduct_vue_vue_type_style_index_0_lang = "";
const _hoisted_1$2 = { class: "card-header is-relative" };
const _hoisted_2$1 = {
  class: "tag ml-1 is-light",
  style: { "font-size": "10px" }
};
const _hoisted_3$1 = {
  key: 0,
  class: "btn-next"
};
const _hoisted_4$1 = /* @__PURE__ */ createBaseVNode("i", {
  class: "fas fa-arrow-right ml-2",
  style: { "font-size": "0.8rem" }
}, null, -1);
const _hoisted_5$1 = { class: "card-body p-0" };
const _hoisted_6$1 = { class: "table-container" };
const _hoisted_7$1 = { class: "table-container" };
const _hoisted_8$1 = { class: "table is-striped is-narrow is-hoverable is-fullwidth order-item" };
const _hoisted_9$1 = { key: 0 };
const _hoisted_10$1 = { class: "has-text-danger" };
const _sfc_main$2 = /* @__PURE__ */ defineComponent({
  props: {
    product: { type: null, required: true, default: Object },
    view: { type: null, required: true, default: Object }
  },
  emits: ["setProducts"],
  setup(__props, { emit }) {
    const props = __props;
    const loading = ref(false);
    const isLoaderActive = ref(false);
    useCommandSession();
    const changeStatus = async (id) => {
      loading.value = true;
      try {
        const response = await provideApi().get(`restaurant/command-status/set/${id}`);
        const data = response.data;
        if (data.success) {
          emit("setProducts");
        }
      } catch (error) {
        console.error("Error data:", error);
      }
      loading.value = false;
    };
    const statusMessageMapping = {
      1: "Preparar",
      2: "Listo",
      3: "Entregar"
    };
    const changeStatusMessageName = (status) => {
      if (!status) {
        return "Preparar";
      }
      return statusMessageMapping[status] || "Preparar";
    };
    const statusClass = (status) => {
      switch (status) {
        case 1:
          return "is-warning";
        case 2:
          return "is-primary";
        case 3:
          return "is-info";
        default:
          return "is-light";
      }
    };
    return (_ctx, _cache) => {
      const _component_VPlaceloadText = _sfc_main$3;
      const _component_VLoader = _sfc_main$4;
      return openBlock(), createElementBlock(Fragment, null, [
        createBaseVNode("div", _hoisted_1$2, [
          createBaseVNode("p", {
            class: normalizeClass([{
              "is-mesa": !isNaN(props.product.mesa)
            }, "card-header-title m-0 p-2 has-text-primary title is-5"])
          }, [
            createTextVNode(toDisplayString(props.product.mesa) + " ", 1),
            createBaseVNode("span", _hoisted_2$1, toDisplayString(props.product.environment), 1)
          ], 2),
          props.product.status < 4 ? (openBlock(), createElementBlock("div", _hoisted_3$1, [
            loading.value ? (openBlock(), createBlock(_component_VPlaceloadText, {
              key: 0,
              lines: 1,
              width: "100%",
              "last-line-width": "25%"
            })) : (openBlock(), createElementBlock("a", {
              key: 1,
              class: normalizeClass([
                "card-footer-item",
                "button",
                "is-light",
                "m-1",
                statusClass(props.product.status)
              ]),
              onClick: _cache[0] || (_cache[0] = ($event) => changeStatus(props.product.id))
            }, [
              createTextVNode(toDisplayString(changeStatusMessageName(props.product.status)) + " ", 1),
              _hoisted_4$1
            ], 2))
          ])) : createCommentVNode("", true)
        ]),
        createVNode(_component_VLoader, {
          size: "small",
          active: isLoaderActive.value,
          translucent: ""
        }, {
          default: withCtx(() => [
            createBaseVNode("div", _hoisted_5$1, [
              createBaseVNode("div", _hoisted_6$1, [
                createBaseVNode("div", _hoisted_7$1, [
                  createBaseVNode("table", _hoisted_8$1, [
                    createBaseVNode("tr", null, [
                      createBaseVNode("td", null, [
                        createBaseVNode("span", null, toDisplayString(props.product.quantity), 1),
                        createTextVNode(" " + toDisplayString(props.product.name), 1)
                      ])
                    ]),
                    props.product.note ? (openBlock(), createElementBlock("tr", _hoisted_9$1, [
                      createBaseVNode("td", _hoisted_10$1, toDisplayString(props.product.note), 1)
                    ])) : createCommentVNode("", true)
                  ])
                ])
              ])
            ])
          ]),
          _: 1
        }, 8, ["active"])
      ], 64);
    };
  }
});
var CommandRestaurant_vue_vue_type_style_index_0_lang = "";
const _hoisted_1$1 = { class: "page-content kanban-content is-relative" };
const _hoisted_2 = { class: "columns is-multiline is-mobile" };
const _hoisted_3 = { class: "column is-1" };
const _hoisted_4 = { class: "column is-11" };
const _hoisted_5 = { class: "tabs-wrapper" };
const _hoisted_6 = { class: "tabs-inner" };
const _hoisted_7 = { class: "tabs is-boxed is-left mb-1" };
const _hoisted_8 = {
  style: {},
  class: ""
};
const _hoisted_9 = { class: "" };
const _hoisted_10 = /* @__PURE__ */ createBaseVNode("span", { class: "has-text-dark" }, [
  /* @__PURE__ */ createBaseVNode("i", {
    "aria-hidden": "true",
    class: "iconify",
    "data-icon": "feather:grid"
  })
], -1);
const _hoisted_11 = [
  _hoisted_10
];
const _hoisted_12 = ["onClick"];
const _hoisted_13 = /* @__PURE__ */ createBaseVNode("li", { class: "tab-naver" }, null, -1);
const _hoisted_14 = { class: "columns is-kanban-wrapper" };
const _hoisted_15 = { class: "collapsed-content" };
const _hoisted_16 = /* @__PURE__ */ createBaseVNode("i", {
  "aria-hidden": "true",
  class: "iconify",
  "data-icon": "feather:plus"
}, null, -1);
const _hoisted_17 = [
  _hoisted_16
];
const _hoisted_18 = { class: "task-count" };
const _hoisted_19 = /* @__PURE__ */ createBaseVNode("div", { class: "collapsed-text" }, "Recibidos", -1);
const _hoisted_20 = { class: "expanded-content" };
const _hoisted_21 = { class: "column-title" };
const _hoisted_22 = /* @__PURE__ */ createBaseVNode("input", {
  type: "text",
  class: "input is-small rename-input is-hidden"
}, null, -1);
const _hoisted_23 = { class: "task-count tag is-danger px-2 py-1 is-inline" };
const _hoisted_24 = /* @__PURE__ */ createBaseVNode("span", { class: "column-name" }, " Recibidos ", -1);
const _hoisted_25 = {
  key: 0,
  class: "kanban-empty"
};
const _hoisted_26 = { class: "empty-text" };
const _hoisted_27 = ["data-id"];
const _hoisted_28 = { class: "collapsed-content" };
const _hoisted_29 = /* @__PURE__ */ createBaseVNode("i", {
  "aria-hidden": "true",
  class: "iconify",
  "data-icon": "feather:plus"
}, null, -1);
const _hoisted_30 = [
  _hoisted_29
];
const _hoisted_31 = { class: "task-count" };
const _hoisted_32 = /* @__PURE__ */ createBaseVNode("div", { class: "collapsed-text" }, "Preparando", -1);
const _hoisted_33 = { class: "expanded-content" };
const _hoisted_34 = { class: "column-title" };
const _hoisted_35 = /* @__PURE__ */ createBaseVNode("input", {
  type: "text",
  class: "input is-small rename-input is-hidden"
}, null, -1);
const _hoisted_36 = { class: "task-count tag is-warning px-2 py-1 is-inline" };
const _hoisted_37 = /* @__PURE__ */ createBaseVNode("span", { class: "column-name" }, " Preparando ", -1);
const _hoisted_38 = {
  key: 0,
  class: "kanban-empty"
};
const _hoisted_39 = { class: "empty-text" };
const _hoisted_40 = ["data-id"];
const _hoisted_41 = { class: "collapsed-content" };
const _hoisted_42 = /* @__PURE__ */ createBaseVNode("i", {
  "aria-hidden": "true",
  class: "iconify",
  "data-icon": "feather:plus"
}, null, -1);
const _hoisted_43 = [
  _hoisted_42
];
const _hoisted_44 = { class: "task-count" };
const _hoisted_45 = /* @__PURE__ */ createBaseVNode("div", { class: "collapsed-text" }, "Por entregar", -1);
const _hoisted_46 = { class: "expanded-content" };
const _hoisted_47 = { class: "column-title" };
const _hoisted_48 = /* @__PURE__ */ createBaseVNode("input", {
  type: "text",
  class: "input is-small rename-input is-hidden"
}, null, -1);
const _hoisted_49 = { class: "task-count tag is-primary px-2 py-1 is-inline" };
const _hoisted_50 = /* @__PURE__ */ createBaseVNode("span", { class: "column-name" }, " Por entregar ", -1);
const _hoisted_51 = {
  key: 0,
  class: "kanban-empty"
};
const _hoisted_52 = { class: "empty-text" };
const _hoisted_53 = ["data-id"];
const _hoisted_54 = { class: "collapsed-content" };
const _hoisted_55 = /* @__PURE__ */ createBaseVNode("i", {
  "aria-hidden": "true",
  class: "iconify",
  "data-icon": "feather:plus"
}, null, -1);
const _hoisted_56 = [
  _hoisted_55
];
const _hoisted_57 = { class: "task-count" };
const _hoisted_58 = /* @__PURE__ */ createBaseVNode("div", { class: "collapsed-text" }, "Entregados", -1);
const _hoisted_59 = { class: "expanded-content" };
const _hoisted_60 = { class: "column-title" };
const _hoisted_61 = /* @__PURE__ */ createBaseVNode("input", {
  type: "text",
  class: "input is-small rename-input is-hidden"
}, null, -1);
const _hoisted_62 = { class: "task-count tag is-secondary px-2 py-1 is-inline" };
const _hoisted_63 = /* @__PURE__ */ createBaseVNode("span", { class: "column-name" }, " Entregados ", -1);
const _hoisted_64 = {
  key: 0,
  class: "kanban-empty"
};
const _hoisted_65 = { class: "empty-text" };
const _hoisted_66 = ["data-id"];
const _sfc_main$1 = /* @__PURE__ */ defineComponent({
  setup(__props) {
    const userSession = useUserSession();
    const roleCurrent = userSession.userRole;
    const role = ROLES.find((role2) => role2.id === roleCurrent);
    const disableBar = ref(true);
    const disableKitchen = ref(true);
    useMesaSession().mesas;
    let intervalId = void 0;
    const defaultView = () => {
      let response = COMMAND_KITCHEN;
      if (role && role.id != 3) {
        if (role.code == "BAR") {
          response = COMMAND_BAR;
          disableBar.value = false;
        }
        if (role.code == "KIT") {
          response = COMMAND_KITCHEN;
          disableKitchen.value = false;
        }
      }
      if ((role == null ? void 0 : role.id) == 3) {
        disableBar.value = false;
        disableKitchen.value = false;
      }
      return response;
    };
    let currentView = ref(defaultView());
    const isColumnPreparationCollapsed = ref(false);
    const isColumnDispatchedCollapsed = ref(false);
    const isColumnToDeliverCollapsed = ref(false);
    const isColumnDeliveredCollapsed = ref(false);
    const isLoaderActive = ref(false);
    const emptyText = ref("No existe registro actualmente");
    useCommandSession();
    ref([]);
    let productsStatusReceived = ref([]);
    let productsStatusProcessing = ref([]);
    let productsStatusToDeliver = ref([]);
    let productsStatusDelivered = ref([]);
    const companySession = useCompanySession();
    const configuration = companySession.configuration;
    const selectedTableId = ref(0);
    const mesasSession = useMesaSession();
    const mesasDisabled = mesasSession.getMesasNotAvailable();
    const getProductsApi = async () => {
      var _a;
      try {
        let id = (_a = selectedTableId.value) != null ? _a : 0;
        const response = await provideApi().get(`restaurant/command-status/items/${id}`);
        const data = response.data;
        if (data.success) {
          productsStatusReceived.value = data.data.productsStatusReceived;
          productsStatusProcessing.value = data.data.productsStatusProcessing;
          productsStatusToDeliver.value = data.data.productsStatusToDeliver;
          productsStatusDelivered.value = data.data.productsStatusDelivered;
        }
      } catch (error) {
        console.error("Error data:", error);
      }
    };
    const selectTable = (id) => {
      selectedTableId.value = id;
      getProductsApi();
    };
    const environmentMapping = {
      "Ambiente 2": "2",
      "Ambiente 3": "3",
      "Ambiente 4": "4"
    };
    const changeEnvironmentName = (name) => {
      if (!name) {
        return "1";
      }
      return environmentMapping[name] || "1";
    };
    const changeView = (view) => {
      currentView.value = view;
      getProductsApi();
    };
    onMounted(() => {
      changeView(currentView.value);
      getProductsApi();
      intervalId = window.setInterval(getProductsApi, 5e3);
    });
    onUnmounted(() => {
      if (intervalId !== void 0) {
        clearInterval(intervalId);
      }
    });
    return (_ctx, _cache) => {
      const _component_VButton = _sfc_main$5;
      const _component_VButtons = _sfc_main$6;
      const _component_KanbanDropdown = _sfc_main$7;
      const _component_CommandProduct = _sfc_main$2;
      const _component_VLoader = _sfc_main$4;
      return openBlock(), createElementBlock("div", _hoisted_1$1, [
        createBaseVNode("div", _hoisted_2, [
          createBaseVNode("div", _hoisted_3, [
            createVNode(_component_VButtons, null, {
              default: withCtx(() => [
                unref(configuration).menu_kitchen ? (openBlock(), createBlock(_component_VButton, {
                  key: 0,
                  icon: "fas fa-concierge-bell",
                  color: unref(currentView).code == unref(COMMAND_KITCHEN).code && "primary",
                  disabled: disableKitchen.value,
                  onClick: _cache[0] || (_cache[0] = ($event) => changeView(unref(COMMAND_KITCHEN)))
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(unref(COMMAND_KITCHEN).name), 1)
                  ]),
                  _: 1
                }, 8, ["color", "disabled"])) : createCommentVNode("", true)
              ]),
              _: 1
            })
          ]),
          createBaseVNode("div", _hoisted_4, [
            createBaseVNode("div", _hoisted_5, [
              createBaseVNode("div", _hoisted_6, [
                createBaseVNode("div", _hoisted_7, [
                  createBaseVNode("ul", _hoisted_8, [
                    createBaseVNode("li", _hoisted_9, [
                      createBaseVNode("a", {
                        onClick: _cache[1] || (_cache[1] = ($event) => selectTable(0))
                      }, _hoisted_11)
                    ]),
                    (openBlock(true), createElementBlock(Fragment, null, renderList(unref(mesasDisabled), (tab, key) => {
                      return openBlock(), createElementBlock("li", {
                        key,
                        class: normalizeClass([selectedTableId.value == tab.id && "is-active"])
                      }, [
                        createBaseVNode("a", {
                          class: "list-table has-text-dark",
                          onClick: ($event) => selectTable(tab.id)
                        }, [
                          createBaseVNode("span", null, [
                            createTextVNode("M" + toDisplayString(tab.label) + " ", 1),
                            createBaseVNode("sub", null, toDisplayString(changeEnvironmentName(tab.environment)), 1)
                          ])
                        ], 8, _hoisted_12)
                      ], 2);
                    }), 128)),
                    _hoisted_13
                  ])
                ])
              ])
            ])
          ])
        ]),
        createBaseVNode("div", _hoisted_14, [
          createBaseVNode("div", {
            class: normalizeClass(["column", [
              isColumnPreparationCollapsed.value && "is-1 is-mini",
              !isColumnPreparationCollapsed.value && "is-one-quarter"
            ]])
          }, [
            createVNode(_component_VLoader, {
              size: "small",
              active: isLoaderActive.value,
              translucent: ""
            }, {
              default: withCtx(() => [
                createBaseVNode("div", {
                  class: normalizeClass(["kanban-column state-1", [isColumnPreparationCollapsed.value && "is-collapsed"]])
                }, [
                  createBaseVNode("div", _hoisted_15, [
                    createBaseVNode("div", {
                      class: "expand-button",
                      onClick: _cache[2] || (_cache[2] = ($event) => isColumnPreparationCollapsed.value = false)
                    }, _hoisted_17),
                    createBaseVNode("div", null, [
                      createBaseVNode("span", _hoisted_18, toDisplayString(unref(productsStatusReceived).length), 1)
                    ]),
                    _hoisted_19
                  ]),
                  createBaseVNode("div", _hoisted_20, [
                    createBaseVNode("div", _hoisted_21, [
                      _hoisted_22,
                      createBaseVNode("h3", null, [
                        createBaseVNode("span", _hoisted_23, toDisplayString(unref(productsStatusReceived).length), 1),
                        _hoisted_24
                      ]),
                      createVNode(_component_KanbanDropdown, {
                        onCollapse: _cache[3] || (_cache[3] = ($event) => isColumnPreparationCollapsed.value = true)
                      })
                    ]),
                    createBaseVNode("div", {
                      ref: (_value, _refs) => {
                        _refs["newContainer"] = _value;
                      },
                      "data-state": "preparation"
                    }, [
                      unref(productsStatusReceived).length === 0 ? (openBlock(), createElementBlock("div", _hoisted_25, [
                        createBaseVNode("p", _hoisted_26, toDisplayString(emptyText.value), 1)
                      ])) : createCommentVNode("", true),
                      (openBlock(true), createElementBlock(Fragment, null, renderList(unref(productsStatusReceived), (item, index) => {
                        return openBlock(), createElementBlock("div", {
                          key: index,
                          "data-id": item.id,
                          class: "kanban-card is-new"
                        }, [
                          createVNode(_component_CommandProduct, {
                            product: item,
                            view: unref(currentView),
                            onSetProducts: getProductsApi
                          }, null, 8, ["product", "view"])
                        ], 8, _hoisted_27);
                      }), 128))
                    ], 512)
                  ])
                ], 2)
              ]),
              _: 1
            }, 8, ["active"])
          ], 2),
          createBaseVNode("div", {
            class: normalizeClass(["column", [
              isColumnDispatchedCollapsed.value && "is-1 is-mini",
              !isColumnDispatchedCollapsed.value && "is-one-quarter"
            ]])
          }, [
            createVNode(_component_VLoader, {
              size: "small",
              active: isLoaderActive.value,
              translucent: ""
            }, {
              default: withCtx(() => [
                createBaseVNode("div", {
                  class: normalizeClass(["kanban-column state-2", [isColumnDispatchedCollapsed.value && "is-collapsed"]])
                }, [
                  createBaseVNode("div", _hoisted_28, [
                    createBaseVNode("div", {
                      class: "expand-button",
                      onClick: _cache[4] || (_cache[4] = ($event) => isColumnDispatchedCollapsed.value = false)
                    }, _hoisted_30),
                    createBaseVNode("div", null, [
                      createBaseVNode("span", _hoisted_31, toDisplayString(unref(productsStatusProcessing).length), 1)
                    ]),
                    _hoisted_32
                  ]),
                  createBaseVNode("div", _hoisted_33, [
                    createBaseVNode("div", _hoisted_34, [
                      _hoisted_35,
                      createBaseVNode("h3", null, [
                        createBaseVNode("span", _hoisted_36, toDisplayString(unref(productsStatusProcessing).length), 1),
                        _hoisted_37
                      ]),
                      createVNode(_component_KanbanDropdown, {
                        onCollapse: _cache[5] || (_cache[5] = ($event) => isColumnDispatchedCollapsed.value = true)
                      })
                    ]),
                    createBaseVNode("div", {
                      ref: (_value, _refs) => {
                        _refs["newContainer"] = _value;
                      },
                      "data-state": "preparation"
                    }, [
                      unref(productsStatusProcessing).length === 0 ? (openBlock(), createElementBlock("div", _hoisted_38, [
                        createBaseVNode("p", _hoisted_39, toDisplayString(emptyText.value), 1)
                      ])) : createCommentVNode("", true),
                      (openBlock(true), createElementBlock(Fragment, null, renderList(unref(productsStatusProcessing), (item, index) => {
                        return openBlock(), createElementBlock("div", {
                          key: index,
                          "data-id": item.id,
                          class: "kanban-card is-new"
                        }, [
                          createVNode(_component_CommandProduct, {
                            product: item,
                            view: unref(currentView),
                            onSetProducts: getProductsApi
                          }, null, 8, ["product", "view"])
                        ], 8, _hoisted_40);
                      }), 128))
                    ], 512)
                  ])
                ], 2)
              ]),
              _: 1
            }, 8, ["active"])
          ], 2),
          createBaseVNode("div", {
            class: normalizeClass(["column", [
              isColumnToDeliverCollapsed.value && "is-1 is-mini",
              !isColumnToDeliverCollapsed.value && "is-one-quarter"
            ]])
          }, [
            createVNode(_component_VLoader, {
              size: "small",
              active: isLoaderActive.value,
              translucent: ""
            }, {
              default: withCtx(() => [
                createBaseVNode("div", {
                  class: normalizeClass(["kanban-column state-3", [isColumnToDeliverCollapsed.value && "is-collapsed"]])
                }, [
                  createBaseVNode("div", _hoisted_41, [
                    createBaseVNode("div", {
                      class: "expand-button",
                      onClick: _cache[6] || (_cache[6] = ($event) => isColumnToDeliverCollapsed.value = false)
                    }, _hoisted_43),
                    createBaseVNode("div", null, [
                      createBaseVNode("span", _hoisted_44, toDisplayString(unref(productsStatusToDeliver).length), 1)
                    ]),
                    _hoisted_45
                  ]),
                  createBaseVNode("div", _hoisted_46, [
                    createBaseVNode("div", _hoisted_47, [
                      _hoisted_48,
                      createBaseVNode("h3", null, [
                        createBaseVNode("span", _hoisted_49, toDisplayString(unref(productsStatusToDeliver).length), 1),
                        _hoisted_50
                      ]),
                      createVNode(_component_KanbanDropdown, {
                        onCollapse: _cache[7] || (_cache[7] = ($event) => isColumnToDeliverCollapsed.value = true)
                      })
                    ]),
                    createBaseVNode("div", {
                      ref: (_value, _refs) => {
                        _refs["newContainer"] = _value;
                      },
                      "data-state": "preparation"
                    }, [
                      unref(productsStatusToDeliver).length === 0 ? (openBlock(), createElementBlock("div", _hoisted_51, [
                        createBaseVNode("p", _hoisted_52, toDisplayString(emptyText.value), 1)
                      ])) : createCommentVNode("", true),
                      (openBlock(true), createElementBlock(Fragment, null, renderList(unref(productsStatusToDeliver), (item, index) => {
                        return openBlock(), createElementBlock("div", {
                          key: index,
                          "data-id": item.id,
                          class: "kanban-card is-new"
                        }, [
                          createVNode(_component_CommandProduct, {
                            product: item,
                            view: unref(currentView),
                            onSetProducts: getProductsApi
                          }, null, 8, ["product", "view"])
                        ], 8, _hoisted_53);
                      }), 128))
                    ], 512)
                  ])
                ], 2)
              ]),
              _: 1
            }, 8, ["active"])
          ], 2),
          createBaseVNode("div", {
            class: normalizeClass(["column", [
              isColumnDeliveredCollapsed.value && "is-1 is-mini",
              !isColumnDeliveredCollapsed.value && "is-one-quarter"
            ]])
          }, [
            createVNode(_component_VLoader, {
              size: "small",
              active: isLoaderActive.value,
              translucent: ""
            }, {
              default: withCtx(() => [
                createBaseVNode("div", {
                  class: normalizeClass(["kanban-column state-4", [isColumnDeliveredCollapsed.value && "is-collapsed"]])
                }, [
                  createBaseVNode("div", _hoisted_54, [
                    createBaseVNode("div", {
                      class: "expand-button",
                      onClick: _cache[8] || (_cache[8] = ($event) => isColumnDeliveredCollapsed.value = false)
                    }, _hoisted_56),
                    createBaseVNode("div", null, [
                      createBaseVNode("span", _hoisted_57, toDisplayString(unref(productsStatusDelivered).length), 1)
                    ]),
                    _hoisted_58
                  ]),
                  createBaseVNode("div", _hoisted_59, [
                    createBaseVNode("div", _hoisted_60, [
                      _hoisted_61,
                      createBaseVNode("h3", null, [
                        createBaseVNode("span", _hoisted_62, toDisplayString(unref(productsStatusDelivered).length), 1),
                        _hoisted_63
                      ]),
                      createVNode(_component_KanbanDropdown, {
                        onCollapse: _cache[9] || (_cache[9] = ($event) => isColumnDeliveredCollapsed.value = true)
                      })
                    ]),
                    createBaseVNode("div", {
                      ref: (_value, _refs) => {
                        _refs["newContainer"] = _value;
                      },
                      "data-state": "preparation"
                    }, [
                      unref(productsStatusDelivered).length === 0 ? (openBlock(), createElementBlock("div", _hoisted_64, [
                        createBaseVNode("p", _hoisted_65, toDisplayString(emptyText.value), 1)
                      ])) : createCommentVNode("", true),
                      (openBlock(true), createElementBlock(Fragment, null, renderList(unref(productsStatusDelivered), (item, index) => {
                        return openBlock(), createElementBlock("div", {
                          key: index,
                          "data-id": item.id,
                          class: "kanban-card is-new"
                        }, [
                          createVNode(_component_CommandProduct, {
                            product: item,
                            view: unref(currentView),
                            onSetProducts: getProductsApi
                          }, null, 8, ["product", "view"])
                        ], 8, _hoisted_66);
                      }), 128))
                    ], 512)
                  ])
                ], 2)
              ]),
              _: 1
            }, 8, ["active"])
          ], 2)
        ])
      ]);
    };
  }
});
const _hoisted_1 = { class: "page-content-inner" };
const _sfc_main = /* @__PURE__ */ defineComponent({
  setup(__props) {
    pageTitle.value = "Pedidos";
    useHead({
      title: "Pedidos"
    });
    return (_ctx, _cache) => {
      const _component_CommandRestaurant = _sfc_main$1;
      return openBlock(), createElementBlock("div", _hoisted_1, [
        createVNode(_component_CommandRestaurant)
      ]);
    };
  }
});
export { _sfc_main as default };
