import { b as defineComponent, f as openBlock, g as createElementBlock, z as toDisplayString, Y as normalizeClass } from "./vendor.f66678d1.js";
import { p as provideApi } from "./index.62345777.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  props: {
    label: { type: [String, Number], required: false, default: void 0 },
    color: { type: String, required: false, default: void 0 },
    rounded: { type: Boolean, required: false },
    curved: { type: Boolean, required: false },
    outlined: { type: Boolean, required: false },
    elevated: { type: Boolean, required: false },
    remove: { type: Boolean, required: false }
  },
  setup(__props) {
    const props = __props;
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("small", {
        class: normalizeClass(["tag", [
          props.color && "is-" + props.color,
          props.rounded && "is-rounded",
          props.curved && "is-curved",
          props.outlined && "is-outlined",
          props.elevated && "is-elevated",
          props.remove && "is-delete"
        ]])
      }, toDisplayString(props.label), 3);
    };
  }
});
const setRestaurantFavorite = async (itemId, favorite) => {
  try {
    const payload = { id: itemId };
    const { data } = await provideApi().post("/restaurant/items/restaurant-favorite", payload);
    return data;
  } catch (err) {
    console.error("Error toggling restaurant favorite", err);
    throw err;
  }
};
const getProductsStock = async () => {
  try {
    const { data } = await provideApi().get("/restaurant/items/stock");
    return data;
  } catch (err) {
    console.error("Error fetching products stock", err);
    throw err;
  }
};
const RestaurantService = { setRestaurantFavorite, getProductsStock };
const getProductsByCommandStatus = async (mesaId) => {
  try {
    const { data } = await provideApi().get(`/restaurant/command-status/served/${mesaId}`);
    return data;
  } catch (err) {
    console.error("Error fetching products by command status", err);
    throw err;
  }
};
const CommandStatusService = { getProductsByCommandStatus };
export { CommandStatusService as C, RestaurantService as R, _sfc_main as _ };
